// $Id: CAutoAnimation.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CAutoAnimation.hpp"
using Exponent::GUI::Controls::CAutoAnimation;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CAutoAnimation, CAnimation);

//	===========================================================================
CAutoAnimation::CAutoAnimation(IControlRoot *root, const long uniqueId, const CRect &area) 
			  : CAnimation(root, uniqueId, area)
			  , m_stepIncrement(0.0)
			  , m_animationStyle(e_forward)
			  , m_forward(true)
{
	EXPONENT_CLASS_CONSTRUCTION(CAutoAnimation);
	m_rootControl->getParentWindow()->addTimedObject(this);
	m_animationStyle = e_forward;
	m_forward = true;
}

//	===========================================================================
CAutoAnimation::~CAutoAnimation()
{
	EXPONENT_CLASS_DESTRUCTION(CAutoAnimation);
	m_rootControl->getParentWindow()->removeTimedObject(this);
}

//	===========================================================================
void CAutoAnimation::setAnimationImage(IImage *theImage, const long heightOfEachFrame, const long numberOfFrames)
{
	CAnimation::setAnimationImage(theImage, heightOfEachFrame, numberOfFrames);
	m_stepIncrement = (double)1.0 / (double)numberOfFrames;
}

//	===========================================================================
void CAutoAnimation::setAnimationStyle(const EAnimationStyle style) 
{ 
	m_animationStyle = style; 
	if (m_animationStyle == e_backward)
	{
		this->setValue(1.0);
	}
}

//	===========================================================================
void CAutoAnimation::timerExpired()
{
	switch(m_animationStyle)
	{
		case e_forward:
			m_value += m_stepIncrement;
			if (m_value > 1.0)
			{
				m_value = 0.0;
				this->stopAnimation();
			}
		break;
		case e_forwardLoop:
			m_value += m_stepIncrement;
			if (m_value > 1.0)
			{
				m_value = 0.0;
			}
		break;
		case e_backward:
			m_value -= m_stepIncrement;
			if (m_value < 0.0)
			{
				m_value = 1.0;
				this->stopAnimation();
			}
		break;
		case e_backwardLoop:
			m_value -= m_stepIncrement;
			if (m_value < 0.0)
			{
				m_value = 1.0;
			}
		break;
		case e_bounce:
			if (m_forward)
			{
				m_value += m_stepIncrement;
				if (m_value > 1.0)
				{
					m_forward = false;
				}
			}
			else
			{
				m_value -= m_stepIncrement;
				if (m_value < 0.0)
				{
					m_forward = true;
				}
			}
		break;
	}
	this->update();
}

//	===========================================================================
void CAutoAnimation::startAnimation(const long updateRateInMillseconds)
{
	m_rootControl->getParentWindow()->startTimer(m_uniqueId, updateRateInMillseconds);
}

//	===========================================================================
void CAutoAnimation::stopAnimation()
{
	m_rootControl->getParentWindow()->stopTimer(m_uniqueId);
}